<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
header('Content-Type: application/json');

// Se a requisição for OPTIONS (preflight CORS), apenas retorna sucesso
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Verifica se o parâmetro CPF foi passado
if (!isset($_GET['cpf']) || empty($_GET['cpf'])) {
    http_response_code(400);
    echo json_encode(["error" => "Parâmetro CPF é necessário."]);
    exit();
}

$cpf = preg_replace('/\D/', '', $_GET['cpf']); // Remove caracteres não numéricos

if (strlen($cpf) !== 11) {
    http_response_code(400);
    echo json_encode(["error" => "CPF inválido. Deve conter 11 dígitos numéricos."]);
    exit();
}

$url = "https://apis-cpfapi.xb7m7k.easypanel.host/api/validar-cpf?cpf=" . urlencode($cpf);

$options = [
    "http" => [
        "method" => "GET",
        "header" => "Accept: application/json\r\n"
    ]
];

$context = stream_context_create($options);
$response = @file_get_contents($url, false, $context);

if ($response === FALSE) {
    http_response_code(500);
    echo json_encode(["error" => "Erro ao acessar a API externa."]);
    exit();
}

// Decodifica a resposta JSON para verificar integridade
$data = json_decode($response, true);

if (json_last_error() !== JSON_ERROR_NONE) {
    http_response_code(500);
    echo json_encode(["error" => "Erro ao processar resposta da API externa."]);
    exit();
}

// Retorna os dados da API externa
http_response_code(200);
echo json_encode([
    "status" => "success",
    "data" => $data
]);
?>
