// Service Worker

self.addEventListener("push", (event) => {
  const data = event.data ? event.data.json() : {}; // Expecting { title, body, icon, data: { url } }
  console.log("Push received:", data);

  const title = data.title || "Notificação";
  const options = {
    body: data.body || "Você tem uma nova mensagem.",
    icon: data.icon || "/img/default-logo.png", // Use default or uploaded logo
    badge: "/img/badge.png", // Optional: small icon for notification bar
    data: {
      url: data.data?.url || "/", // URL to open on click
    },
    // tag: "unique-notification-tag" // Optional: group notifications
  };

  event.waitUntil(
    self.registration.showNotification(title, options)
  );
});

self.addEventListener("notificationclick", (event) => {
  console.log("Notification click Received.");

  event.notification.close();

  // Open the URL specified in the notification data
  event.waitUntil(
    clients.openWindow(event.notification.data.url)
  );
});

// Optional: Handle subscription changes or updates
self.addEventListener("pushsubscriptionchange", (event) => {
  console.log("Subscription expired or changed.");
  event.waitUntil(
    self.registration.pushManager.subscribe(event.oldSubscription.options)
      .then((newSubscription) => {
        // TODO: Send the newSubscription.toJSON() to your server to update the endpoint
        console.log("New subscription obtained:", newSubscription);
        // Example: fetch("/update-subscription", { method: "POST", ... })
      })
  );
});

// Basic install/activate listeners for caching (optional for now)
self.addEventListener("install", (event) => {
  console.log("Service Worker installing.");
  // event.waitUntil(self.skipWaiting()); // Activate worker immediately
});

self.addEventListener("activate", (event) => {
  console.log("Service Worker activating.");
  // event.waitUntil(clients.claim()); // Take control of pages immediately
});

